####### Parameter ################
seed<-1
repeat_num<-100
iteration_num<-300
x_grid_num<-15
x_dim_num<-2
x_min<- -2.5
x_max<- 2.5
w_grid_num<-15
w_dim_num<-2
w_min<- -2.5
w_max<- 2.5
ptr_threshold_theta<- 0.18
mae_alpha<-4
kernel_var<-1^2
kernel_length<-10
noise_var<-10^(-6)
fixed_ptr_beta<-9
ptr_epsilon<- 10^(-8)
ptr_m<-10
fixed_ptr_m<-2
fixed_ucb_beta<-3
fixed_BBB_MOBO_beta<-3
theoretical_delta<-0.05
robust_measure<-1		#1: Expectation, 2: PTR, 3: Expectation - mae_alpha*MAE
uncontrollable<-0		#0: Simulator setting, 1: Uncontrollable setting
AF_num<- 1			#1: random, 2: US, 3: Proposed, 4: Proposed_fix, 5: BQ, 6: BPT-UCB, 7: BPT-UCB_fix, 8: BBBMOBO, 9: BBBMOBO_fix  
##################################




####### Input ####################
X1<- seq(x_min,x_max,length=x_grid_num)
all_X<-cbind(X1)
if(x_dim_num > 1)
{
	for(i in 1:(x_dim_num-1))
	{
	all_X<- cbind(all_X%x%rep(1,x_grid_num),rep(1,x_grid_num)%x%X1)
	}
}

W1<- seq(w_min,w_max,length=w_grid_num)
all_W<-cbind(W1)
if(w_dim_num > 1)
{
	for(i in 1:(w_dim_num-1))
	{
	all_W<- cbind(all_W%x%rep(1,w_grid_num),rep(1,w_grid_num)%x%W1)
	}
}

all_input<- cbind(all_X%x%rep(1,w_grid_num^w_dim_num),rep(1,x_grid_num^x_dim_num)%x%all_W)
all_input_num<-length(all_input[,1])
all_x_num<-length(all_X[,1])
all_w_num<-length(all_W[,1])

##################################

standard_normal_pdf<-function(x)
{
(2*pi)^(-1/2)*exp(-x^2/2)
}

####### Probability mass function for w ############
w_pmf<- apply((0.25*standard_normal_pdf(all_W-1)+0.75*standard_normal_pdf(all_W+5)),1,prod)/(sum( apply((0.25*standard_normal_pdf(all_W-1)+0.75*standard_normal_pdf(all_W+5)),1,prod)))
##################################


####### True function ############
tf<-function(x)
{
a1<-x[1] + x[3]
a2<-x[2] + 0.5 * x[4]

(-((a1^2+a2-11)^2+(a1+a2^2-7)^2 ) + 104.8905)/sqrt(3281.531)
}

true_function_mat<- t(matrix(apply(all_input,1,tf),all_w_num,all_x_num))


##################################


####### Function ############
#compute_kernel<-function(x1,x2)
#{
#kernel_var*exp(-sum((x1-x2)^2)/kernel_length)
#}

compute_kernel2<-function(x)
{
n1<- length(x)/2
n2<- length(x)
kernel_var*exp(-sum((x[1:n1]-x[(n1+1):n2])^2)/kernel_length)
}

compute_kernel_expectation<-function(x)
{
mat_A<-cbind(all_input,rbind(x)%x%rep(1,all_input_num))
mat_B<-matrix(apply(mat_A,1,compute_kernel2),all_w_num,all_x_num)
colSums(mat_B*w_pmf)
}

compute_expectation_prior_var<-function(x)
{
mat_A<-cbind(rbind(x)%x%rep(1,all_w_num),all_W)
mat_B<-cbind(mat_A%x%rep(1,all_w_num),rep(1,all_w_num)%x%mat_A)
mat_C<-matrix(apply(mat_B,1,compute_kernel2),all_w_num,all_w_num)
sum(colSums(mat_C*w_pmf)*w_pmf)
}


##################################

########## Expectation prior var ###########
expectation_prior_var<-compute_expectation_prior_var(all_X[1,])*rep(1,all_x_num)
############################################



####### result mat ###############
result_mat_exp<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_ptr<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_exp_mae<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
##################################


##################################
##################################
##################################
########### OPTIMIZE #############
##################################
##################################
##################################
for(w in 1:repeat_num)
{
set.seed((seed-1)*repeat_num+w)
true_function<- true_function_mat


true_expectation<- as.vector(true_function%*%w_pmf)
true_ptr<- as.vector((true_function>=ptr_threshold_theta)%*%w_pmf)
true_exp_mae<- true_expectation- mae_alpha* as.vector(abs(true_function-true_expectation%x%rbind(rep(1,all_w_num)))%*%w_pmf)



max_true_expectation<-max(true_expectation)
max_true_ptr<-max(true_ptr)
max_true_exp_mae<-max(true_exp_mae)




k_vec_mat<- all_input[,1]%x%t(numeric(iteration_num))
k_vec_mat2<- all_X[,1]%x%t(numeric(iteration_num))


input<-c()
Y<-c()
x_num<-c()
w_num<-c()

new_x_num<- sample(c(1:length(all_X[,1])),1)
new_w_num<- sample(c(1:length(all_W[,1])),1)

new_x<- all_X[new_x_num,]
new_w<- all_W[new_w_num,]
new_input<- c(new_x,new_w)

new_y<- true_function[new_x_num,new_w_num] + rnorm(1,0,sqrt(noise_var))


	for(ww in 1:iteration_num)
	{
	input<-rbind(input,new_input)
	Y<-c(Y,new_y)
	x_num<-c(x_num,new_x_num)
	w_num<-c(w_num,new_w_num)
	input_num<- (x_num-1)*all_w_num+w_num

	k_vec_mat[,ww]<-  apply(cbind(all_input,rbind(new_input)%x%rep(1,all_input_num)),1,compute_kernel2)
	K<-as.matrix(k_vec_mat[input_num,1:ww])
	C<- K+ noise_var*diag(ww)
	Cinv<- solve(C)

	post_mean<- as.vector(cbind(k_vec_mat[,1:ww])%*%Cinv%*%Y) 
	post_var<- abs(kernel_var-rowSums((cbind(k_vec_mat[,1:ww])%*%Cinv)*cbind(k_vec_mat[,1:ww])))

	post_mean_matrix<- t(matrix(post_mean,all_w_num,all_x_num))	

	est_expectation<- as.vector(post_mean_matrix%*%w_pmf)
	est_ptr<- as.vector((post_mean_matrix>=ptr_threshold_theta)%*%w_pmf)
	est_exp_mae<- est_expectation- mae_alpha* as.vector(abs(post_mean_matrix-est_expectation%x%rbind(rep(1,all_w_num)))%*%w_pmf)



	result_mat_exp[w,ww]<- max_true_expectation-true_expectation[order(est_expectation,decreasing=T)[1]]
	result_mat_ptr[w,ww]<- max_true_ptr-true_ptr[order(est_ptr,decreasing=T)[1]]
	result_mat_exp_mae[w,ww]<- max_true_exp_mae-true_exp_mae[order(est_exp_mae,decreasing=T)[1]]

		########################## acquisition function ###################################
		if(AF_num==1)
		{
		new_x_num<- sample(c(1:length(all_X[,1])),1)
		new_w_num<- c(1:all_w_num)[as.vector(rmultinom(1,c(1:all_w_num),w_pmf))==1]
		}

		if(AF_num==2)
		{
		max_post_var_num<- order(post_var,decreasing=T)[1]
		new_x_num<-ceiling(max_post_var_num/all_w_num)
		new_w_num<-max_post_var_num-(new_x_num-1)*all_w_num
		}

		if(AF_num==3)
		{
		beta<- sqrt(2*log(all_input_num)	+rgamma(1,1,1/2)	)
		ucb_f<- post_mean + beta*sqrt(post_var)
		lcb_f<- post_mean - beta*sqrt(post_var)

			if(robust_measure==1)
			{
			ucb_F<-   as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)
			lcb_F<-   as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)
			max_est_num<- order(est_expectation,decreasing=T)[1]
			}

			if(robust_measure==2)
			{
			ucb_F<-   as.vector((t(matrix(ucb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			lcb_F<-   as.vector((t(matrix(lcb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			max_est_num<- order(est_ptr,decreasing=T)[1]

			}

			if(robust_measure==3)
			{
			u_check<- t(matrix(ucb_f,all_w_num,all_x_num)) - as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))
			l_check<- t(matrix(lcb_f,all_w_num,all_x_num)) - as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))

			ucb_mae<- as.vector((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)>=abs(u_check)))%*%w_pmf)
			lcb_mae<-as.vector(((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)<=abs(u_check)))-(-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))*((-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))>=0))%*%w_pmf)
			
			ucb_F<- 	as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*lcb_mae
			lcb_F<- 	as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*ucb_mae
			max_est_num<- order(est_exp_mae,decreasing=T)[1]


			}

		max_ucb_F_num<- order(ucb_F,decreasing=T)[1]

			if(	(ucb_F[max_ucb_F_num]-lcb_F[max_ucb_F_num])>=(ucb_F[max_est_num]-lcb_F[max_est_num])					)
			{
			new_x_num<- max_ucb_F_num
			} else {
			new_x_num<- max_est_num
			}

		new_w_num<-order(post_var[((new_x_num-1)*all_w_num+1):(new_x_num*all_w_num)],decreasing=T)[1]

		}
		
		if(AF_num==4)
		{
		beta<- fixed_ucb_beta
		ucb_f<- post_mean + beta*sqrt(post_var)
		lcb_f<- post_mean - beta*sqrt(post_var)

			if(robust_measure==1)
			{
			ucb_F<-   as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)
			lcb_F<-   as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)
			max_est_num<- order(est_expectation,decreasing=T)[1]
			}

			if(robust_measure==2)
			{
			ucb_F<-   as.vector((t(matrix(ucb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			lcb_F<-   as.vector((t(matrix(lcb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			max_est_num<- order(est_ptr,decreasing=T)[1]

			}

			if(robust_measure==3)
			{
			u_check<- t(matrix(ucb_f,all_w_num,all_x_num)) - as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))
			l_check<- t(matrix(lcb_f,all_w_num,all_x_num)) - as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))

			ucb_mae<- as.vector((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)>=abs(u_check)))%*%w_pmf)
			lcb_mae<-as.vector(((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)<=abs(u_check)))-(-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))*((-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))>=0))%*%w_pmf)
			
			ucb_F<- 	as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*lcb_mae
			lcb_F<- 	as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*ucb_mae
			max_est_num<- order(est_exp_mae,decreasing=T)[1]


			}

		max_ucb_F_num<- order(ucb_F,decreasing=T)[1]

			if(	(ucb_F[max_ucb_F_num]-lcb_F[max_ucb_F_num])>=(ucb_F[max_est_num]-lcb_F[max_est_num])					)
			{
			new_x_num<- max_ucb_F_num
			} else {
			new_x_num<- max_est_num
			}

		new_w_num<-order(post_var[((new_x_num-1)*all_w_num+1):(new_x_num*all_w_num)],decreasing=T)[1]

		}


		if(AF_num==5)
		{
		k_vec_mat2[,ww]<-compute_kernel_expectation(new_input)
		post_BQ_mean<- as.vector(k_vec_mat2[,1:ww]%*%Cinv%*%Y)
		post_BQ_var<- abs(expectation_prior_var - rowSums((k_vec_mat2[,1:ww]%*%Cinv)*k_vec_mat2[,1:ww]))
		post_BQ_mean_max<- max(post_BQ_mean)
		Z<- (post_BQ_mean-post_BQ_mean_max)/(sqrt(post_BQ_var))
		BQ_EI<- sqrt(post_BQ_var)*( Z*pnorm(Z)+standard_normal_pdf(Z)  )
		new_x_num<- order(BQ_EI,decreasing=T)[1]
		new_w_num<-order(post_var[((new_x_num-1)*all_w_num+1):(new_x_num*all_w_num)],decreasing=T)[1]
		}

		if(AF_num==6)
		{
		beta<-all_input_num*pi^2*ww^2/(3*theoretical_delta)
		ptr_eta<- 0.5*min(ptr_epsilon*sqrt(kernel_var)/2,ptr_epsilon^2*theoretical_delta*sqrt(kernel_var)/(8*all_input_num))

		post_mean_m<-t(matrix(post_mean,all_w_num,all_x_num))
		post_sqrt_m<-t(matrix(sqrt(post_var),all_w_num,all_x_num))


		eta_neibor<- abs(post_mean_m-ptr_threshold_theta)<ptr_eta
		new_ptr_threshold_theta<- 	ptr_threshold_theta+	eta_neibor*2*ptr_eta
		
		pnorm_mat<-pnorm((post_mean_m-new_ptr_threshold_theta)/post_sqrt_m)
		pnorm_mat2<- pnorm_mat*(1-pnorm_mat)

		post_mean_p<- as.vector(pnorm_mat%*%w_pmf)
		post_gamma_2<- as.vector(pnorm_mat2%*%w_pmf)
		ptr_ucb<-post_mean_p+ beta^(1/ptr_m)*post_gamma_2^(1/ptr_m)
		new_x_num<- order(ptr_ucb,decreasing=T)[1]
		new_w_num<-order(pnorm_mat2[new_x_num,],decreasing=T)[1]
		}

		if(AF_num==7)
		{
		beta<-fixed_ptr_beta
		ptr_eta<- 0.5*min(ptr_epsilon*sqrt(kernel_var)/2,ptr_epsilon^2*theoretical_delta*sqrt(kernel_var)/(8*all_input_num))

		post_mean_m<-t(matrix(post_mean,all_w_num,all_x_num))
		post_sqrt_m<-t(matrix(sqrt(post_var),all_w_num,all_x_num))


		eta_neibor<- abs(post_mean_m-ptr_threshold_theta)<ptr_eta
		new_ptr_threshold_theta<- 	ptr_threshold_theta+	eta_neibor*2*ptr_eta
		
		pnorm_mat<-pnorm((post_mean_m-new_ptr_threshold_theta)/post_sqrt_m)
		pnorm_mat2<- pnorm_mat*(1-pnorm_mat)

		post_mean_p<- as.vector(pnorm_mat%*%w_pmf)
		post_gamma_2<- as.vector(pnorm_mat2%*%w_pmf)
		ptr_ucb<-post_mean_p+ beta^(1/fixed_ptr_m)*post_gamma_2^(1/fixed_ptr_m)
		new_x_num<- order(ptr_ucb,decreasing=T)[1]
		new_w_num<-order(pnorm_mat2[new_x_num,],decreasing=T)[1]
		}


		if(AF_num==8)
		{
		beta<- sqrt(2*log(all_input_num*pi^2*ww^2/(6*theoretical_delta)))
		ucb_f<- post_mean + beta*sqrt(post_var)
		lcb_f<- post_mean - beta*sqrt(post_var)

			if(robust_measure==1)
			{
			ucb_F<-   as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)
			lcb_F<-   as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)
			}

			if(robust_measure==2)
			{
			ucb_F<-   as.vector((t(matrix(ucb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			lcb_F<-   as.vector((t(matrix(lcb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)

			}

			if(robust_measure==3)
			{
			u_check<- t(matrix(ucb_f,all_w_num,all_x_num)) - as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))
			l_check<- t(matrix(lcb_f,all_w_num,all_x_num)) - as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))

			ucb_mae<- as.vector((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)>=abs(u_check)))%*%w_pmf)
			lcb_mae<-as.vector(((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)<=abs(u_check)))-(-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))*((-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))>=0))%*%w_pmf)
			
			ucb_F<- 	as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*lcb_mae
			lcb_F<- 	as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*ucb_mae


			}

		new_x_num<- order(ucb_F,decreasing=T)[1]
		new_w_num<-order(post_var[((new_x_num-1)*all_w_num+1):(new_x_num*all_w_num)],decreasing=T)[1]

		}

		if(AF_num==9)
		{
		beta<- fixed_BBB_MOBO_beta
		ucb_f<- post_mean + beta*sqrt(post_var)
		lcb_f<- post_mean - beta*sqrt(post_var)

			if(robust_measure==1)
			{
			ucb_F<-   as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)
			lcb_F<-   as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)
			}

			if(robust_measure==2)
			{
			ucb_F<-   as.vector((t(matrix(ucb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)
			lcb_F<-   as.vector((t(matrix(lcb_f,all_w_num,all_x_num))>=ptr_threshold_theta)%*%w_pmf)

			}

			if(robust_measure==3)
			{
			u_check<- t(matrix(ucb_f,all_w_num,all_x_num)) - as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))
			l_check<- t(matrix(lcb_f,all_w_num,all_x_num)) - as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf)%x%rbind(rep(1,all_w_num))

			ucb_mae<- as.vector((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)>=abs(u_check)))%*%w_pmf)
			lcb_mae<-as.vector(((abs(u_check) + (abs(l_check)- abs(u_check))*(abs(l_check)<=abs(u_check)))-(-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))*((-l_check + ( u_check - (-l_check)   )*(u_check<=(-l_check)  ))>=0))%*%w_pmf)
			
			ucb_F<- 	as.vector(t(matrix(ucb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*lcb_mae
			lcb_F<- 	as.vector(t(matrix(lcb_f,all_w_num,all_x_num))%*%w_pmf) - mae_alpha*ucb_mae


			}

		new_x_num<- order(ucb_F,decreasing=T)[1]
		new_w_num<-order(post_var[((new_x_num-1)*all_w_num+1):(new_x_num*all_w_num)],decreasing=T)[1]

		}


		

	###################################################################################
	
	if(uncontrollable==1)
	{
	new_w_num<- c(1:all_w_num)[as.vector(rmultinom(1,c(1:all_w_num),w_pmf))==1]
	}

	
	new_x<- all_X[new_x_num,]
	new_w<- all_W[new_w_num,]
	new_input<- c(new_x,new_w)

	new_y<- true_function[new_x_num,new_w_num] + rnorm(1,0,sqrt(noise_var))




	}

}



write.table(result_mat_exp,"result_mat_exp.txt")
write.table(result_mat_ptr,"result_mat_ptr.txt")
write.table(result_mat_exp_mae,"result_mat_exp_mae.txt")



